import { Button } from "@/components/ui/button";
import { DialogClose, DialogContent, DialogDescription, DialogHeader, DialogTitle } from "@/components/ui/dialog";
import { ComponentWithClassNameAndChildren } from "@/types/utils";

export function ErrorNoAgenciesContent({ className, children }: ComponentWithClassNameAndChildren) {
  return (
    <DialogContent className={className}>
      <DialogHeader>
        <DialogTitle>Unable to work with services...</DialogTitle>
        <DialogDescription>
          We are currently not accepting new services or service edits at this time. Try again at a later date.

          {children}
        </DialogDescription>
      </DialogHeader>

      <div className="flex flex-row gap-2 justify-end">
        <DialogClose asChild>
          <Button variant={"secondary"}>Close</Button>
        </DialogClose>
      </div>
    </DialogContent>
  )

}
